/*
  get/set file time
  written by alexander yaworsky
  september '99
*/

#include <windows.h>

#include "filetime.h"
#include "switches.h"


BOOL GetLocalFileTime( char* FileName, SYSTEMTIME* Stm )
  {
    FILETIME   Ftm, Ltm;
    HANDLE     Fh;
    DWORD      LastErr;

    Fh = CreateFile( FileName, GENERIC_READ, FILE_SHARE_READ,
                     NULL, OPEN_EXISTING, 0, NULL );
    if( Fh == INVALID_HANDLE_VALUE ) return FALSE;
    if( ! GetFileTime( Fh, NULL, NULL, &Ftm ) ) {
      LastErr = GetLastError();
      CloseHandle( Fh );
      SetLastError( LastErr );
      return FALSE;
    }
    CloseHandle( Fh );
    FileTimeToLocalFileTime( &Ftm, &Ltm );
    FileTimeToSystemTime( &Ltm, Stm );
    return TRUE;
  }

BOOL SetLocalFileTime( char* FileName, SYSTEMTIME* Stm )
  {
    FILETIME   Ftm, Ltm;
    HANDLE     Fh;
    DWORD      LastErr;

    Fh = CreateFile( FileName, GENERIC_WRITE, FILE_SHARE_WRITE,
                     NULL, OPEN_EXISTING, 0, NULL );
    if( Fh == INVALID_HANDLE_VALUE ) return FALSE;
    SystemTimeToFileTime( Stm, &Ltm );
    LocalFileTimeToFileTime( &Ltm, &Ftm );
    if( ! SetFileTime( Fh, NULL, NULL, &Ftm ) ) {
      LastErr = GetLastError();
      CloseHandle( Fh );
      SetLastError( LastErr );
      return FALSE;
    }
    CloseHandle( Fh );
    return TRUE;
  }
